unit Fantasy;

interface
uses StdCtrls;

procedure MakeRandomFantasy (RqMemo : TMemo);

implementation

function RandomHero() : string;
begin
  case Random(4) of
  0 : Result := '';
  1 : Result := '';
  2 : Result := '';
  3 : Result := '';
  end;
end;

function RandomSity() : string;
begin
  case Random(4) of
  0 : Result := '';
  1 : Result := '';
  2 : Result := '';
  3 : Result := '';
  end;
end;

procedure RandomWay(RqMemo : TMemo);
var Ind : integer;
begin
  for Ind := 0 to 1 + Random(3) do
  begin
   RqMemo.Lines.Add('-, -, -, -, -, -,');
  end;
end;

function RandomLandscape() : string;
begin
  case Random(4) of
  0 : Result := '-       !';
  1 : Result := '-  ,       ...';
  2 : Result := '-   ,         ...';
  3 : Result := '-           ...';
  end;
end;

function RandomOpponent() : string;
begin
  case Random(4) of
  0 : Result := '';
  1 : Result := '';
  2 : Result := '';
  3 : Result := '';
  end;
end;

function Randomattle() : string;
begin
  case Random(3) of
  0 : Result := '- ! ! ! ! ---! !  ...';
  1 : Result := '- ! ! ! ! ---! !  ...';
  2 : Result := '- ! ! ! ! ---!  ....';
  end;
end;

procedure MakeRandomFantasy(RqMemo : TMemo);
var HeroName, SityName, OpponentName, WStr : string;
begin
  RqMemo.Clear;
  Randomize();
  HeroName := RandomHero();
  SityName := RandomSity();
  OpponentName := RandomOpponent();

  // 
  RqMemo.Lines.Add('  .');
  RqMemo.Lines.Add('(   - )');
  RqMemo.Lines.Add('');

  // 
  WStr := '   '  + HeroName
        + '     ' + SityName + '.';
  RqMemo.Lines.Add(WStr);
  RqMemo.Lines.Add('    .');
  WStr := ' ' + HeroName
        + '      ... ';
  RqMemo.Lines.Add(WStr);

  //  
  RandomWay(RqMemo);
  RqMemo.Lines.Add('----- ...');
  RqMemo.Lines.Add(RandomLandscape());
  RqMemo.Lines.Add('   ,'
                 + '      ...');

  // 
  RandomWay(RqMemo);
  RqMemo.Lines.Add('- ---- !!!');
  WStr := ' ,    ,    '
        + OpponentName + '.';
  RqMemo.Lines.Add(WStr);
  WStr := ' '+ HeroName
        + '      ... ';
  RqMemo.Lines.Add(WStr);
  RqMemo.Lines.Add(Randomattle());

  // 
  WStr := '   ' + OpponentName
        + '    -    '
        + HeroName  + '.';
  RqMemo.Lines.Add(WStr);
  RqMemo.Lines.Add(' -      ... ');

  //  
  RandomWay(RqMemo);

  // 
  RqMemo.Lines.Add('       ');
  RqMemo.Lines.Add('   ' + SityName + '.');
  RqMemo.Lines.Add(' ' + HeroName + '    .');
  RqMemo.Lines.Add('');
  RqMemo.Lines.Add(' ( ).');
end;


end.
